classdef SGEClusterInfo < handle
%CLUSTERINFO ClusterInfo class.
%
%   Provides cluster information about:
%      ClusterHost
%      DataLocation
%      ProcsPerNode
%      ProjectName
%      UserNameOnCluser
%      WallTime
%
%   Example:
%     ClusterInfo.setDataLocation('\\server\data');
%     dl = ClusterInfo.getDataLocation();

%   Copyright 2009 The MathWorks, Inc.
%   Raymond S. Norris (raymond.norris@mathworks.com)
%   $Revision$ $Date$

   methods (Static,Access='private')
      function gp = Group()
         gp = 'SGEClusterInfo';
      end
   end
   
   methods (Static)
      function clearClusterInfo()
         try
            rmpref(ClusterInfo.Group)
         catch E %#ok<NASGU>
         end
      end


      function setExtraParameter(pa)
         if nargin==0 || ischar(pa)==false
            error('distcomp:clusterinfo:InvalidType','Extra Parameter must be a character string.')
         end
         setpref(SGEClusterInfo.Group,'ExtraParameter',pa)
      end
      function pa = getExtraParameter()
         try
            val = getpref(SGEClusterInfo.Group,'ExtraParameter');
         catch E %#ok<NASGU>
            val = [];
         end
         pa = val;
      end

  
   end

end
